% ------------------------------------------------------------------------
% Script: Default
% ------------------------------------------------------------------------
% Aim:
% 1/ To load its default value if the value of one parameter is not defined
%    in the infile.m file. 
% 2/ To judge whether the value of parameters defined in the infile.m file 
%    is wrong or not. If wrong, the PNADIS code will stop with outputting 
%    the error information. 
% ------------------------------------------------------------------------

defaultend=0;

%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core Structure
% ------------------------------------------------------------------------

    % % The absolute path to save the result files

    if ~exist('filepath','var') || isempty(filepath)

        fprintf('    >> WARNING!!! The default value of filepath=pwd is used \n');
        filepath=pwd;

    end

    % % the dimension of P-N model ( 1 or 2 )

    if exist('misdim','var')

        if misdim~=1 && misdim~=2
            fprintf('    >> ERROR!!! The value of misdim could only be 1 or 2 \n');
            return
        end

    else
        fprintf('    >> ERROR!!! The value of misdim was not defined \n');
        return
    end
    
    % % Calculating the dislocation core Structure ('TRUE') or NOT ('FALSE')
        
	if exist('Dislocation_Core_Structure','var')

        if ~strcmp(Dislocation_Core_Structure,'TRUE') && ~strcmp(Dislocation_Core_Structure,'FALSE')
            fprintf('    >> ERROR!!! The value of Peierls_Stress could only be ''TRUE'' or ''FALSE'' \n');
            return
        end
        
	else
        fprintf('    >> WARNING!!! The default value of Dislocation_Core_Structure=''TRUE'' is used \n');
        Dislocation_Core_Structure='TRUE';
	end  
            
    if strcmp(Dislocation_Core_Structure,'TRUE')

        % % the data of stacking fault energy (SFE:J/m2) and displacement (Ux and Uz:1)

        if ~exist('Ux','var') || ~exist('SFE','var')
            fprintf('    >> ERROR!!! The value of Ux or SFE (or Ux, Uz or SFE) was not defined \n');
            return
        else
            % % % 
            if size(Ux,1)~=size(SFE,1) || size(Ux,2)~=size(SFE,2)
                fprintf('    >> ERROR!!! The Inner matrix dimensions of Ux and SFE (or Ux, Uz and SFE) must agree. \n');
                return
            end
        end

        if misdim==2

            if ~exist('Uz','var')
                fprintf('    >> ERROR!!! The value of Ux or SFE (or Ux, Uz or SFE) was not defined \n');
                return
            else
                % % % 
                if size(Uz,1)~=size(SFE,1) || size(Uz,2)~=size(SFE,2)
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of Ux and SFE (or Ux, Uz and SFE) must agree. \n');
                    return
                end   
            end

        end

        % % a set of Nmis discrete partial dislocations

        if exist('Nmis','var')

            if misdim==1
                if Nmis~=fix(Nmis) || Nmis<1
                    fprintf('    >> ERROR!!! The value of Nmis must be >=1 and integral for 1D P-N model');
                    return
                end
            elseif misdim==2
                if Nmis~=fix(Nmis) || Nmis<-1
                    fprintf('    >> ERROR!!! The value of Nmis must be >=-1 and integral for 2D P-N model');
                    return
                end
            end

        else

            if misdim==1
                fprintf('    >> WARNING!!! The default value of Nmis=3 is used for 1D P-N model \n');
                Nmis=3;
            elseif misdim==2
                fprintf('    >> WARNING!!! The default value of Nmis=0 is used for 2D P-N model \n');
                Nmis=0;
            end

        end

        % % The shear modulus and Poisson's ratio (unit: GPa)

        if ~exist('shear_modulus','var') || isempty(shear_modulus)
            fprintf('    >> ERROR!!! The value of shear_modulus was not defined \n');
            return
        end

        if ~exist('poisson_ratio','var') || isempty(poisson_ratio)
            fprintf('    >> ERROR!!! The value of poisson_ratio was not defined \n');
            return
        end    

        % % edge or screw dislocation: the dislocation line along z axis ('e')
          %                            the dislocation line along x axis ('s')

        if exist('mistype','var')
            if mistype~='e' && mistype~='s'
                fprintf('    >> ERROR!!! The value of mistype could only be ''e'' or ''s'' \n');
                return
            end
        else
            fprintf('    >> WARNING!!! The default value of mistype=''e'' is used \n');
            mistype='e';
        end

        % % the cut data for fitting the SFE data

        if exist('fitcut','var')

            if misdim==1
                if fitcut~=fix(fitcut) || fitcut<0
                    fprintf('    >> ERROR!!! The value of fitcut must be >=0 and integral for 1D P-N model');
                    return
                end
            elseif misdim==2
                if fitcut~=fix(fitcut) || fitcut<-1
                    fprintf('    >> ERROR!!! The value of fitcut must be >=-1 and integral for 2D P-N model');
                    return
                end
            end

        else
            fprintf('    >> WARNING!!! The default value of fitcut=0 is used \n');
            fitcut=0;
        end

        % % The Burgers Vector (unit: A)

        if ~exist('BurVect','var') || isempty(BurVect)
            fprintf('    >> ERROR!!! The value of BurVect was not defined \n');
            return
        end

        % % ------------------------------------------------------
        % % For these parameters only for 1D Peierls-Nabarro Model
        % % ------------------------------------------------------

        if misdim==1

            % % % considering the first-order approximation in disregistry function ot NOT
            if exist('mis_1st','var')
                if mis_1st~=0 && mis_1st~=1
                    fprintf('    >> ERROR!!! The value of mis_1st could only be 0 or 1 \n');
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of mis_1st=0 is used \n');
                mis_1st=0;
            end

            % % matrix of ranges for each input variable ([Lower, Upper, StartPoint]) 

            if exist('Xcoef_range','var')
                if size(Xcoef_range,1)*size(Xcoef_range,2)~=3
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of Xcoef_range must be 1x3 or 3x1 \n');
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of Xcoef_range=[0.0000,1.0000,1/Nmis] is used \n');
                Xcoef_range=[  0.0000,  1.0000,  1/Nmis];
            end

            if exist('Xdist_range','var')
                if size(Xdist_range,1)*size(Xdist_range,2)~=3
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of Xdist_range must be 1x3 or 3x1 \n');
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of Xdist_range=[-50.0000,50.0000,0.0000] is used \n');
                Xdist_range=[-50.0000, 50.0000,  0.0000];
            end

            if exist('Xwid_range','var')
                if size(Xwid_range,1)*size(Xwid_range,2)~=3
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of Xwid_range must be 1x3 or 3x1 \n');
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of Xwid_range=[0.0000,10.0000,5.0000] is used \n');
                Xwid_range=[  0.0000, 10.0000,  5.0000];
            end

            if mis_1st==1

                if exist('Xalpha_range','var')
                    if size(Xalpha_range,1)*size(Xalpha_range,2)~=3
                        fprintf('    >> ERROR!!! The Inner matrix dimensions of Xalpha_range must be 1x3 or 3x1 \n');
                        return
                    end
                else
                    fprintf('    >> WARNING!!! The default value of Xalpha_range=[0.0000,2.0000,1.0000] is used \n');
                    Xalpha_range=[  0.0000, 2.0000,  1.0000];
                end

            end

            % % The Fitting Mothed "1d_fitting_toolbox" and "1d_lsq_curvefit"

            if exist('fitmethod','var')

                if ~strcmp(fitmethod,'1d_fitting_toolbox') && ~strcmp(fitmethod,'1d_lsq_curvefit')
                    fprintf('    >> ERROR!!! The value of fitmethod could only be ''1d_fitting_toolbox'' or ''1d_lsq_curvefit'' \n');
                    return
                end

            else
                fprintf('    >> WARNING!!! The default value of fitmethod=''1d_lsq_curvefit'' is used \n');
                fitmethod='1d_lsq_curvefit';
            end      

        % % ------------------------------------------------------
        % % For these parameters only for 2D Peierls-Nabarro Model
        % % ------------------------------------------------------

        elseif misdim==2

            % % % mode of PN modles: Classical P-N model (pnmode=1)
            % %                      Semidiscrete Variational P-N model (pnmode=2)

            if exist('pnmode','var')
                if pnmode~=1 && pnmode~=2
                    fprintf('    >> ERROR!!! The value of pnmode could only be 1 or 2 \n')
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of pnmode=1 is used \n');
                pnmode=1;
            end

            % % The minimization method 2d_particle_swarm_optimization ("2d_PSO") and
            %   2d_genetic_algorithm ("2d_GA")

            if exist('minimethod','var')

                if ~strcmp(minimethod,'2d_PSO') && ~strcmp(minimethod,'2d_GA')
                    fprintf('    >> ERROR!!! The value of minimethod could only be ''2d_PSO'' or ''2d_GA'' \n')
                    return
                end

            else
                fprintf('    >> WARNING!!! The default value of minimethod=''2d_PSO'' is used \n');
                minimethod='2d_PSO';
            end

            % % PSO or GA parameters

            % % % Maximum number of iterations before the algorithm halts
            if ~exist('MaxIterations','var') || isempty(MaxIterations)
                fprintf('    >> WARNING!!! The default value of MaxIterations=1000 is used \n');
                MaxIterations=1000;
            end

            % % % Size of the population
            if ~exist('PopulationSize','var') || isempty(PopulationSize)
                fprintf('    >> WARNING!!! The default value of PopulationSize=1000 is used \n');
                PopulationSize=1000;  
            end

            % % matrix of ranges for each input variable ([Lower, Upper, StartPoint])

            if exist('Xdist_range','var')
                if size(Xdist_range,1)*size(Xdist_range,2)~=3
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of Xdist_range must be 1x3 or 3x1 \n');
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of Xdist_range=[-50.0000,50.0000,0.0000] is used \n');
                Xdist_range=[-50.0000, 50.0000,  0.0000];
            end

            if exist('Xwid_range','var')
                if size(Xwid_range,1)*size(Xwid_range,2)~=3
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of Xwid_range must be 1x3 or 3x1 \n');
                    return
                end
            else
                fprintf('    >> WARNING!!! The default value of Xwid_range=[0.0000,10.0000,5.0000] is used \n');
                Xwid_range=[  0.0000, 10.0000,  5.0000];
            end

            if Nmis>=1 || Nmis==-1

                if exist('Xcoef_range','var')
                    if size(Xcoef_range,1)*size(Xcoef_range,2)~=3
                        fprintf('    >> ERROR!!! The Inner matrix dimensions of Xcoef_range must be 1x3 or 3x1 \n');
                        return
                    end
                else
                    fprintf('    >> WARNING!!! The default value of Xcoef_range=[0.0000,1.0000,0.5000] is used \n');
                    Xcoef_range=[  0.0000,  1.0000,  0.5000];
                end

                if Nmis==-1

                    if exist('dx_range','var')
                        if size(dx_range,1)*size(dx_range,2)~=3
                            fprintf('    >> ERROR!!! The Inner matrix dimensions of dx_range must be 1x3 or 3x1 \n');
                            return
                        end
                    else
                        fprintf('    >> WARNING!!! The default value of dx_range=[-5.0000,5.0000,0.0000] is used \n');
                        dx_range=[ -5.0000,  5.0000,  0.0000];
                    end

                end

            end

            % % ----------------------------------
            % % For these parameters only for SVPN
            % % ----------------------------------

            if pnmode==2

                % % some input paremeters only for Semidiscrete Variational P-N model

                if ~exist('dax','var') || isempty(dax)
                    fprintf('    >> WARNING!!! The default value of dax=0 is used \n');
                    dax=0;
                end

                % % Interpanar spacing in the direction of dislocation sliding for SVPN 
                %   or the calculation of Peierls stress

                if ~exist('Inpas','var') || isempty(Inpas)
                    fprintf('    >> ERROR!!! The value of Inpas for Semidiscrete Variational P-N model was not defined \n');
                    return
                end

                % % whether consider the gradient energy or NOT and the gradient
                %   coefficient only for SVPN model (i.e. pnmode=2)

                if exist('GradientEnergy','var')

                    if GradientEnergy~=0 && GradientEnergy~=1
                        fprintf('    >> ERROR!!! The value of GradientEnergy could only be 0 or 1 \n');
                        return
                    end

                else
                    fprintf('    >> WARNING!!! The default value of GradientEnergy=0 is used \n');
                    GradientEnergy=0;
                end

                if GradientEnergy==1
                    if ~exist('grad_coef','var') || isempty(grad_coef)
                        fprintf('    >> ERROR!!! The value of grad_coef for gradient energy was not defined \n');
                        return
                    end
                end
                        
                % % whether consider the nonlocal energy or NOT and the nonlocal
                %   coefficient only for SVPN model (i.e. pnmode=2) 

                if exist('NonlocalEnergy','var')

                    if NonlocalEnergy~=0 && NonlocalEnergy~=1
                        fprintf('    >> ERROR!!! The value of NonlocalEnergy could only be 0 or 1 \n');
                        return
                    end

                else
                    fprintf('    >> WARNING!!! The default value of NonlocalEnergy=0 is used \n');
                    NonlocalEnergy=0;
                end

                if NonlocalEnergy==1
                    if ~exist('nonloc_coef','var') || isempty(nonloc_coef)
                        fprintf('    >> ERROR!!! The value of nonloc_coef for nonlocal energy was not defined \n');
                        return
                    end
                end        
                
                % % whether consider the stress energy or NOT and the applied stress
                %   only for SVPN model (i.e. pnmode=2)

                if exist('StressEnergy','var')

                    if StressEnergy~=0 && StressEnergy~=1
                        fprintf('    >> ERROR!!! The value of StressEnergy could only be 0 or 1 \n');
                        return
                    end

                else
                    fprintf('    >> WARNING!!! The default value of StressEnergy=0 is used \n');
                    StressEnergy=0;
                end

                if StressEnergy==1
                    if ~exist('str_coef','var') || isempty(str_coef)
                        fprintf('    >> ERROR!!! The value of str_coef for stress energy was not defined \n');
                        return
                    end
                end
            end

        end  

    end  
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------

    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    if exist('Peierls_Stress','var')

        if ~strcmp(Peierls_Stress,'TRUE') && ~strcmp(Peierls_Stress,'FALSE')
            fprintf('    >> ERROR!!! The value of Peierls_Stress could only be ''TRUE'' or ''FALSE'' \n');
            return
        end  
        
    else
        fprintf('    >> WARNING!!! The default value of Peierls_Stress=''FALSE'' is used \n');
        Peierls_Stress='FALSE';
    end
    
    if strcmp(Peierls_Stress,'TRUE')

        % % % The method to calculated the Peierls stress ()

        if exist('pnstrmethod','var')

            if pnstrmethod~=1 && pnstrmethod~=2
                fprintf('    >> ERROR!!! The value of pnstrmethod could only be 1 or 2 \n');
                return
            end

        else
            fprintf('    >> WARNING!!! The default value of pnstrmethod=2 is used \n');
            pnstrmethod=2;
        end

        if pnstrmethod==2
            % % Interpanar spacing in the direction of dislocation sliding for the
            %   calculation of Peierls stress
            if ~exist('Inpas','var') || isempty(Inpas)
                fprintf('    >> ERROR!!! The value of Inpas for Peierls stress via the method of pnstrmethod=2 was not defined \n');
                return
            end
        end
        
        % if misdim==1 && pnstrmethod==3
        %     fprintf('    >> ERROR!!! The method of xxx to calculate the Peierls stress is not available for 1D P-N model \n');
        %     return
        % end
        
    end
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field
% ------------------------------------------------------------------------

    % % Calculating the pressure field or NOT

    if exist('Pressure_Field','var')
        
        if ~strcmp(Pressure_Field,'TRUE') && ~strcmp(Pressure_Field,'FALSE')
            fprintf('    >> ERROR!!! The value of Pressure_Field could only be ''TRUE'' or ''FALSE'' \n');
            return           
        end
        
    else
        fprintf('    >> WARNING!!! The default value of Pressure_Field=''FALSE'' is used \n');
        Pressure_Field='FALSE';
    end

    if strcmp(Pressure_Field,'TRUE')
            
        % % % The lattice xx and yy

        if ~exist('pressfld_latxz','var') || ~exist('pressfld_latyy','var')
            fprintf('    >> ERROR!!! The value of pressfld_latxz or pressfld_latyy for pressure field calculation was not defined \n');
            return
        else
            % % % %
            if size(pressfld_latxz,1)~=size(pressfld_latyy,1) || size(pressfld_latxz,2)~=size(pressfld_latyy,2)
                fprintf('    >> ERROR!!! The Inner matrix dimensions of pressfld_latxz and pressfld_latyy must agree. \n');
                return
            end
        end
        
        if misdim==2
            
            if exist('dis_component_xz','var')

                if dis_component_xz~='x' && dis_component_xz~='z'
                    fprintf('    >> ERROR!!! The value of dis_component_xz could only be ''x'' or ''z'' \n');
                    return           
                end

            else
                fprintf('    >> WARNING!!! The default value of dis_component_xz=''x'' is used \n');
                dis_component_xz='x';
            end
            
        end
        
    end
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------

    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    if misdim==2
    
        if exist('Solution_Strengthening','var')

            if ~strcmp(Solution_Strengthening,'TRUE') && ~strcmp(Solution_Strengthening,'FALSE')
                fprintf('    >> ERROR!!! The value of Solution_Strengthening could only be ''TRUE'' or ''FALSE'' \n');
                return
            end
        
        else
            fprintf('    >> WARNING!!! The default value of Solution_Strengthening=''FALSE'' is used \n');
            Solution_Strengthening='FALSE';
        end

        if strcmp(Solution_Strengthening,'TRUE')

            % % % the input volume misfit (eb_input) and slip misfit (es_input) parameters

            if ~exist('eb_input','var') || ~exist('es_input','var')
                fprintf('    >> ERROR!!! The value of eb_input or es_input for solution strengthening calculation was not defined \n');
                return
            else
                % % % % 
                if size(eb_input,1)~=size(es_input,1) || size(eb_input,2)~=size(es_input,2)
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of eb_input and es_input must agree. \n');
                    return
                end
            end

            % % % The lattice xx and yy

            if ~exist('pressfld_latxz','var') || ~exist('pressfld_latyy','var')
                fprintf('    >> ERROR!!! The value of pressfld_latxz or pressfld_latyy for pressure field calculation was not defined \n');
                return
            else
                % % % %
                if size(pressfld_latxz,1)~=size(pressfld_latyy,1) || size(pressfld_latxz,2)~=size(pressfld_latyy,2)
                    fprintf('    >> ERROR!!! The Inner matrix dimensions of pressfld_latxz and pressfld_latyy must agree. \n');
                    return
                end
            end            
            
            % % % lattice parameter

            if ~exist('LatC_spacing','var') || isempty(LatC_spacing)
                fprintf('    >> ERROR!!! The value of LatC_spacing for solution strengthening calculation was not defined \n');
                return
            end

            % % % Whether to plot the position-dependent dislocation-solute interaction energy or NOT
            
            if exist('Einteraction_Plot','var')

                if ~strcmp(Einteraction_Plot,'TRUE') && ~strcmp(Einteraction_Plot,'FALSE')
                    fprintf('    >> ERROR!!! The value of Einteraction_Plot could only be ''TRUE'' or ''FALSE'' \n');
                    return
                end

            else
                fprintf('    >> WARNING!!! The default value of Einteraction_Plot=''FALSE'' is used \n');
                Einteraction_Plot='FALSE';
            end            
            
            % % % the coefficient of dV=coefV*eb in Einact.m

            if ~exist('coefV','var') || isempty(coefV)
                fprintf('    >> ERROR!!! The value of coefV for solution strengthening calculation was not defined \n');
                return
            end
            
            % % % matrix of the lower and upper bounds to search the characteristic bow-out distance wc unit: A)
            
            if ~exist('wc_range','var') || isempty(wc_range)
                fprintf('    >> WARNING!!! The default value of wc_range=[0, 50] is used \n');
                return
            end            

            % % % concentration of solid solution

            if ~exist('solute_concentration','var') || isempty(solute_concentration)
                fprintf('    >> WARNING!!! The default value of solute_concentration=1 is used \n');
                solute_concentration=1;
            end 
        end
    end
    
%% -----------------------------------------------------------------------
% THE END
% ------------------------------------------------------------------------   

% For end

defaultend=1;