
% ------------------------------------------------------------------------
%                               >>> PNADIS <<<
% ------------------------------------------------------------------------
% 
% PNADIS - Peierls-Nabarro Analyzer for DISlocation core structure and slip
%          resistance
% [C] S. H. Zhang and R. F. Zhang 2018-2019, zrfbuaa group
% --------------------------version 1.0.0-------------------------------
% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the Free
% Software Foundation, either version 3 of the License, or (at your option)
% any later version.
% 
% This program is distributed in the hope that it will be useful, but WITHOUT
% ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
% FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
% for more details.
% 
% You should have received a copy of the GNU General Public License along
% with this program.  If not, see <http://www.gnu.org/licenses/>.
% ------------------------------------------------------------------------
% Input variables:
% 1/ system: System name
% 2/ filepath: The absolute path to save the result files
% 3/ misdim: The dimension of P-N model: 1D or 2D
% 
% >>> The Parameters for the calculation of dislocation core structure
% 1/ Dislocation_Core_Structure: Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
% 2/ Ux, (Uz), SFE: The data of GSFE and normalized disregistry vector
% 3/ Nmis: Which trial function of disregistry vector to employ
% 4/ mis_1st: Considering the first-order approximation in the trial function of disregistry vector or NOT
% 5/ BurVect: The value of Burgers vector
% 6/ shear_modulus, poisson_ratio: The values of shear modulus and Poisson's ratio
% 7/ mistype: The dislocation type: edge or screw
% 8/ fitcut: Which GSFE fitting function to employ
% 9/ pnmode: Mode of P-N models: CCPN or SVPN
% 10/ Inpas: Interplanar distance ?x
% 11/ dax: The reference position x_m is defined as x_m=m?x+dax for SVPN model (m=0, 1, 2, , ?)
% 12/ Xcoef_range, Xdist_range, Xwid_range, Xalpha_range, dx_range: Matrix of the lower and upper bounds, 
%     and initial values of each unknown variable
% 13/ minimethod: The minimization method for 2D P-N model: PSO or GA
% 14/ fitmethod: The mothed for fitting the restoring force "1d_fitting_toolbox" and "1d_lsq_curvefit"
% 15/ PopulationSize, MaxIterations: Size of the population and maximum number of iteration for PSO and GA
% 
% >>> The Parameters for the calculation of Peierls stress
% 1/ Peierls_Stress: Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
% 2/ pnstrmethod: The method to calculate the Peierls stress
% 
% >>> The Parameters for the calculation of pressure field around dislocaiton core
% 1/ Pressure_Field: Calculating the pressure field ('TRUE') or NOT ('FALSE')
% 2/ pressfld_latxz and pressfld_latyy: The lattice matrix for pressure field
% 3/ dis_component_xz: Which component of the dislocation to calculate: x or z
% 
% >>> The Parameters for the calculation of solid solution strengthening
% 1/ Solution_Strengthening: Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
% 2/ Einteraction_Plot: Plotting the position-dependent solute/dislocation interaction energy or NOT
% 3/ eb_input, es_input: The input volumetric misfit and slip misfit parameters
% 4/ LatC_spacing: The interlayer spacing along FCC [111] or HCP [0001] direction
% 5/ coefV: The coefficient to calculate the extra volume, i.e. dV=coefV*eb
% 6/ wc_range: Matrix of the lower and upper bounds to search the characteristic bow-out distance wc
% 7/ solute_concentration: Concentration of solute atom
% 
% ------------------------------------------------------------------------
% Output variables:
% 1/ SFEfit: The fitting data of ?-surface or GSFE
% 2/ gammafitresult: The result of fitting ?-surface or GSFE (MATLAB FUNCTION)
% 3/ gammafiterror: The difference between the fitting and initial GSFE data
% 4/ Uxdata, RestoringForce, RestoringForcefit: The data of restoring force and its fitting value
% 5/ xmis, misfit, misdens: The normalized disregistry and misfit density
% 6/ lb, ub, InitialPopulationMatrix: The lower bound, upper bound and initial population for PSO and GA
% 7/ xmis, misfit_x_axis, misfit_z_axis: The components of normalized disregistry along x and z axes
% 8/ misdens_x_axis, misdens_z_axis: The components of misfit density along x and z axes
% 9/ str_is, half_width, str_pn_narrow , str_pn_wide: The ideal slide stress, half width of dislocation, and the Peierls stress of narrow and wide dislocation
% 10/ upn, Epn, strpn: The Peierls energy barrier and Peierls stress
% 11/ pressure_latxz_mis, pressure_latyy_mis, pressfld: The  position-dependent pressure field around dislocation core
% 12/ Einact_plot: The position-dependent solute/dislocation interaction energy
% 13/ wc, Ebarrier, crss0: The characteristic bow-out distance, the predicted energy barrier and corresponding CRSS at 0K for solid solution strengthening
% 
% ------------------------------------------------------------------------
% Output MAT file:
% 1/ pnadis.mat: all of the inout and output variables
% 
% ------------------------------------------------------------------------
% Output figures:
% >>> For both 1D and 2D P-N models
% 1/ fitgamma.fig: the result of fitting ?-surface or generalized stacking fault energy (GSFE).
% 2/ pressurefield.fig: the result of position-dependent pressure field around dislocation core.
% 3/ pnstress.fig: the result of Peierls energy barrier (Epn) and Peierls stress (strpn) as a function of the position (upn)
%
% >>> Only for 1D P-N model
% 1/ restoring_force.fig: the result of restoring force, which is obtained by deriving the GSFE calculated ab initio.
% 2/ fitrestoringforce.fig: the result of the least square minimization of the difference between the elastic resistance and restoring force to determine the dislocation core structure.
% 3/ misdens.fig: the results of dislocation core structure, including disregistry (misfit) and misfit density (misdens).
% 
% >>> Only for 2D P-N model
% 1/ gammafiterror.fig: the difference (gammafiterror) between the fitting and initial GSFE data vs. Ux and Uz.
% 2/ misfit.fig: the results of dislocation core structure including the components of disregistry along x and z axes.
% 3/ misdens.fig: the results of dislocation core structure including the components of misfit density along x and z axes.
% 4/ Einteraction_[eb]_[es].fig: the result of position-dependent solute/dislocation interaction energy as the volumetric and slip misfit parameters are equal to [eb] and [es] respectively
% 
% ------------------------------------------------------------------------

    % SET PATH

    % path=pwd;
    % index_dir=strfind(path,'\');
    % path_up=path(1:index_dir(end)-1);
    % addpath(genpath(path_up));
    
    addpath(genpath(pwd));
    % savepath;

    % TO START THE CALCULATION

    run StartCal.m
