	#Config:
#----chmod +x VASPMATE
#----chmod +x xxx.sh
#----set environment path
	#Method(reference to code)
#----./xxx.sh [option]
#----[
#---- en //energy !!! if you want to get formation energy, please revise line 56 & 57
#---- band //band
#---- dos //dos
#---- aelas //AELAS
#---- adais //ADAIS
#----]
#----example:
#----spd.sh en 
#----spd.sh band dos
#----spd.sh aelas
#----spd.sh adais

#-------Modifiable-------
VASPMATE="VASPMATE" #If you do not need to use this program, please set it to an empty path
WRONG_DATA="" #The format of wrong data
OUTPUT_FILE="log.sdata" # The output file name
LINUX_LOG="linux_log" # Print Linux error logs to avoid polluting database files
VASPMATE_LOG="vaspmate_log" #Print VASPMATE logs to avoid polluting database files
#------------------------

#-------Immutable--------
const_label="#data"
ATOM_FILE="ATOM_NUM"
ENERGY_FILE="OUTCAR_ENERGY"
GAP_FILE="BAND_GAP"
ELASTIC_FILE="ELADAT"
FERMI_FILE="FERMI_LEVEL"
CONVEX_FILE="convex_hull.txt"
#------------------------

#-------Redirect output-------
exec 1>$OUTPUT_FILE 
exec 2>$LINUX_LOG
#-----------------------------

#-----------------Function To Extract Property--------------------
#-------Energy------
function energy()
{
	#-------get_data--------
	$VASPMATE --en >> $VASPMATE_LOG
	$VASPMATE --atom POSCAR >> $VASPMATE_LOG
	atom=`cat $ATOM_FILE`
	en=`cat $ENERGY_FILE`
	#-------print_data--------
	echo "$const_label	Total_energy"
	echo "scale=3;$en/$atom" | bc
	echo "$const_label	Formation_energy"
	#formation energy [Add your element energy (e1 e2 e3 ...)]
	#$VASPMATE --enth e1 e2 e3... >> $VASPMATE_LOG	#open it
	
}

function hull()
{
	#-------get_data--------
	$VASPMATE --hull
	#-------print_data--------
	echo "$const_label	Convex_hull"
	cat $CONVEX_FILE
}

#-------Electronic-------
function electronic_band()
{
	#-------get_data--------
	$VASPMATE --band -bg >> $VASPMATE_LOG
	if [ -s $GAP_FILE ];then
		Character=`grep "Band Character:" $GAP_FILE | awk '{print $3}'`
		if [ $Character == Metallic ];then
			direct_gap=$WRONG_DATA
			band_gap=$WRONG_DATA
			metallic=2 # 2 : YES 1 : NO
			VBM=$WRONG_DATA
			CBM=$WRONG_DATA
		else
			metallic=1 # 2 : YES 1 : NO
			band_gap=`grep "Band Gap (eV):" $GAP_FILE | awk '{print $4}'`
			if [ $Character == Direct ];then
				direct_gap=2 # Direct
			else
				direct_gap=1 # Indirect
			fi
			VBM_x=`grep "Location of VBM:" $GAP_FILE | awk '{print $4}'` 
			VBM_y=`grep "Location of VBM:" $GAP_FILE | awk '{print $5}'`         
			VBM_z=`grep "Location of VBM:" $GAP_FILE | awk '{print $6}'`
			CBM_x=`grep "Location of CBM:" $GAP_FILE | awk '{print $4}'`
			CBM_y=`grep "Location of CBM:" $GAP_FILE | awk '{print $5}'`
			CBM_z=`grep "Location of CBM:" $GAP_FILE | awk '{print $6}'`
		fi
	fi
	if [ ! -s $FERMI_FILE ];then
		$VASPMATE --dos -efermi >> FERMI_LEVEL
	fi
	fermi=`cat $FERMI_FILE`
	#-----------data-file-------------
	$VASPMATE --band -b >> $VASPMATE_LOG
	#-------print_data--------
	echo "$const_label	Band_structure"
	cat BAND.dat
	echo "$const_label	Band_gap"
	echo "$band_gap"
	echo "$const_label	Direct_gap"
	echo "$direct_gap"
	echo "$const_label	Metallic" 
	echo "$metallic"
	echo "$const_label	Fermi_energy"
	echo "$fermi"
	echo "$const_label	VBM_location"
	echo "$VBM_x	$VBM_y	$VBM_z"
	echo "$const_label	CBM_location"
 	echo "$CBM_x	$CBM_y	$CBM_z"
}

function electronic_dos()
{
	#-------get_data--------
	if [ ! -s $FERMI_FILE ];then
		$VASPMATE --dos -efermi >> FERMI_LEVEL
	fi
	fermi=`cat $FERMI_FILE`
	$VASPMATE --dos -t >> $VASPMATE_LOG
	#-------print_data--------
	echo "$const_label	Density_of_state"
	cat TDOS.dat
	echo "$const_label	Fermi_energy"
	echo "$fermi"
}

#-------Elastic-------
function AELAS()
{
	#-------get_data------
	if [ -s ELADAT ];then
		sti_1=`sed -n '3p' ELADAT`
		sti_2=`sed -n '4p' ELADAT`
		sti_3=`sed -n '5p' ELADAT`
		sti_4=`sed -n '6p' ELADAT`
		sti_5=`sed -n '7p' ELADAT`
		sti_6=`sed -n '8p' ELADAT`
		com_1=`sed -n '12p' ELADAT`
		com_2=`sed -n '13p' ELADAT`
		com_3=`sed -n '14p' ELADAT`
		com_4=`sed -n '15p' ELADAT`
		com_5=`sed -n '16p' ELADAT`
		com_6=`sed -n '17p' ELADAT`
		V_E=`grep "Voigt approximate" ELADAT | awk '{print $3}'`
        V_G=`grep "Voigt approximate" ELADAT | awk '{print $4}'`
        V_B=`grep "Voigt approximate" ELADAT | awk '{print $5}'`
        V_V=`grep "Voigt approximate" ELADAT | awk '{print $6}'`
        R_E=`grep "Reuss approximate" ELADAT | awk '{print $3}'`
        R_G=`grep "Reuss approximate" ELADAT | awk '{print $4}'`
        R_B=`grep "Reuss approximate" ELADAT | awk '{print $5}'`
        R_V=`grep "Reuss approximate" ELADAT | awk '{print $6}'`
		H_E=`grep "Hill approximate" ELADAT | awk '{print $4}'`
		H_G=`grep "Hill approximate" ELADAT | awk '{print $5}'`
		H_B=`grep "Hill approximate" ELADAT | awk '{print $6}'`
		H_V=`grep "Hill approximate" ELADAT | awk '{print $7}'`
		S=`grep "Elastic Stability Conditions:" ELADAT | awk '{print $4}'`
		Pugh=`grep "Pugh" ELADAT | awk '{print $4}'`
		Cauchy=`grep "Cauchy" ELADAT | awk '{print $4}'`
		CBAI=`grep "Chung-Buessem" ELADAT | awk '{print $5}'`
		UEAI=`grep "Universal" ELADAT | awk '{print $6}'`	
	fi
	#-------print_data-------
	echo "$const_label	Stiffness_tensor"
	for i in `seq 1 6`
	do	
		array=`eval echo '$sti_'"${i}"`
		for j in ${array[@]}
        do
			echo -n -e $j"\t"
		done    
		echo -e "\r"
	done
	echo "$const_label	Compliance_tensor"
	for i in `seq 1 6`
	do	
		array=`eval echo '$com_'"${i}"`
		for j in ${array[@]}
        do
			echo -n -e $j"\t"
		done    
		echo -e "\r"
	done
	echo "$const_label	Voigt_Youngs_modulus"
	echo "$V_E"
	echo "$const_label	Voigt_shear_modulus"
	echo "$V_G" 
	echo "$const_label	Voigt_bulk_modulus"
	echo "$V_B" 
	echo "$const_label	Voigt_Poisson_ratio"
	echo "$V_V" 
	echo "$const_label	Reuss_Youngs_modulus"
	echo "$R_E"
	echo "$const_label	Reuss_shear_modulus"
	echo "$R_G" 
	echo "$const_label	Reuss_bulk_modulus"
	echo "$R_B" 
	echo "$const_label	Reuss_Poisson_ratio"
	echo "$R_V" 
	echo "$const_label	Hill_Youngs_modulus"
	echo "$H_E"
	echo "$const_label	Hill_shear_modulus"
	echo "$H_G" 
	echo "$const_label	Hill_bulk_modulus"
	echo "$H_B" 
	echo "$const_label	Hill_Poisson_ratio"
	echo "$H_V" 
	echo "$const_label	Pugh_ratio"
	echo "$Pugh"
	echo "$const_label	Cauchy_pressure"
	echo "$Cauchy"
	echo "$const_label	Chung_Buessem_anisotropy_index"
	echo "$CBAI"
	echo "$const_label	Universal_elastic_anisotropy_index"
	echo "$UEAI"
	echo "$const_label	Elastic_stability_conditions"
	if [ $S == "Stable" ];then
		echo 2 #Stable
	else
		echo 1	#UnStable
	fi
	echo "$S"
}

function ADAIS()
{
	echo "$const_label	Structures"
	cat A*POS*
	title=`sed -n '1p' RDAIS`
	if [[ $title =~ $"Eadhesion" ]]
	then
		echo "$const_label	Eadhesion"
	elif [[ $title =~ $"Stress" ]]
	then
		echo "$const_label	Stress"
	elif [[ $title =~ $"GSFE" ]]
	then
		echo "$const_label	GSFE"
	fi
	cat RDAIS
}


#close redict file to output VASPMATE result to target file
exec 1<&-
$VASPMATE --db >> $VASPMATE_LOG
#open redict 
exec 1>>$OUTPUT_FILE
#-------------A-series--------------
if [[ $1 == ABAND ]];then
	echo "$const_label	Description"
	echo "ABAND	This is a calculation for band structure."
	electronic_band
	electronic_dos;
elif [[ $1 == AEDOS ]];then	
	echo "$const_label	Description"
	echo "AEDOS	This is a calculation for density of state."
	electronic_dos;
elif [[ $1 == AELAS ]];then
	echo "$const_label	Description"
	echo "AELAS	This is a calculation for elastic properties."
	energy
	AELAS
elif [[ $1 == ADAIS ]];then
	echo "$const_label	Description"
	echo "ADAIS	This is a calculation for elastic properties."
	ADAIS
elif [[ $1 == AHULL ]];then
	echo "$const_label	Description"
	echo "AHULL	This is a calculation for convex hull."
	hull
fi
#-------------normal--------------
for arg in "$*"
do
	if [[ $arg == en ]]; then
		energy
	elif [[ $arg == band ]]; then
		electronic_band
	elif [[ $arg == dos ]]; then
		electronic_dos
	elif [[ $arg == aelas ]]; then
		AELAS
	elif [[ $arg == adais ]]; then
		ADAIS
	fi
done
#---------------------------------
echo "#end"
#rm $ATOM_FILE $ENERGY_FILE $GAP_FILE $ELASTIC_FILE $FERMI_FILE $CONVEX_FILE